/* Copyright (c) 2008, Oracle. All rights reserved. */

import java.io.*;
import java.util.*;

public class LASVariableLengthRecord{
	byte[] recordSignature=new byte[2]; // Reserved field
	byte[] userID=new byte[16];
	byte[] recordID=new byte[2];
	byte[] recordLengthAfterHeader=new byte[2];
	byte[] description=new byte[32];
	byte[] data;

	public LASVariableLengthRecord(){
	}

	static LASVariableLengthRecord createGeoKeyDirectoryTagRecord(
        String descriptionString,
        int projectedCSTypeGeoKey,
        int geogGeodeticDatumGeoKey,
        int geogEllipsoidGeoKey,
        int geogPrimeMeridianGeoKey,
        int geogLinearUnitsGeoKey){

		LASVariableLengthRecord lasVariableLengthRecord=new LASVariableLengthRecord();

		lasVariableLengthRecord.recordSignature=lasVariableLengthRecord.intToLittleEndianArray2(0);  //43707?
		lasVariableLengthRecord.userID=lasVariableLengthRecord.stringToArray(lasVariableLengthRecord.userID.length,"LASF_Projection");
		lasVariableLengthRecord.recordID=lasVariableLengthRecord.intToLittleEndianArray2(34735);
		lasVariableLengthRecord.description=lasVariableLengthRecord.stringToArray(lasVariableLengthRecord.description.length,descriptionString);

		Vector<byte[]> vector=new Vector<byte[]>();
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(0));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(6));

		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1024));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(0));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));

		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(3072));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(0));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(projectedCSTypeGeoKey));

		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(2050));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(0));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(geogGeodeticDatumGeoKey));

		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(2056));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(0));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(geogEllipsoidGeoKey));

		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(2051));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(0));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(geogPrimeMeridianGeoKey));

		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(2052));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(0));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(1));
		vector.add(lasVariableLengthRecord.intToLittleEndianArray2(geogLinearUnitsGeoKey));

		lasVariableLengthRecord.data=lasVariableLengthRecord.stackByteVector(vector);

		lasVariableLengthRecord.recordLengthAfterHeader=lasVariableLengthRecord.intToLittleEndianArray2(lasVariableLengthRecord.data.length);
		return lasVariableLengthRecord;
	}

	public byte[] stackByteVector(Vector<byte[]> vector){
		int arraySize=0;
		for(int a=0;a<vector.size();a++){
			arraySize+=vector.get(a).length;
		}
		byte[] byteArray=new byte[arraySize];
		for(int a=0,byteArrayIndex=0;a<vector.size();a++){
			for(int b=0;b<vector.get(a).length;b++,byteArrayIndex++){
				byteArray[byteArrayIndex]=vector.get(a)[b];
			}
		}
		return byteArray;

	}

	public void parse(InputStream inputStream){
		try{
			inputStream.read(recordSignature);
			inputStream.read(userID);
			inputStream.read(recordID);
			inputStream.read(recordLengthAfterHeader);
			inputStream.read(description);
			data=new byte[littleEndianArray2ToInt(recordLengthAfterHeader)];
			inputStream.read(data);

		}catch(Exception exception){
			exception.printStackTrace();
		}
	}

	public void write(OutputStream outputStream){
		try{
			outputStream.write(recordSignature);
			outputStream.write(userID);
			outputStream.write(recordID);
			outputStream.write(recordLengthAfterHeader);
			outputStream.write(description);
			if(data!=null){
				outputStream.write(data);
			}
		}catch(Exception exception){
			exception.printStackTrace();
		}
	}

	public String arrayToString(byte[] array){
		String string=new String(array);
		int breakPoint=string.length();
		for(int a=0;a<string.length();a++){
			if(string.charAt(a)<32 || string.charAt(a)>126){
				breakPoint=a;
				break;
			}
		}
		string=string.substring(0,breakPoint);
		return string;
	}

	public int getRecordLength(){
		int recordLength=recordSignature.length+userID.length+recordID.length+recordLengthAfterHeader.length+description.length;
		if(data!=null){
			recordLength+=data.length;
		}
		return recordLength;
	}

	public byte[] stringToArray(int arraySize,String string){
		byte[] array=new byte[arraySize];
		if(string==null){
			string=new String();
		}
		for(int a=0;a<string.length();a++){
			array[a]=(byte)string.charAt(a);
		}
		for(int a=string.length();a<arraySize;a++){
			array[a]=(char)0x0;
		}
		return array;
	}


	public double littleEndianArray8ToDouble(byte[] array){
		long longBits=(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24)|(((long)array[4]&0xFFL)<<32)|(((long)array[5]&0xFFL)<<40)|(((long)array[6]&0xFFL)<<48)|(((long)array[7]&0xFFL)<<56);
		return java.lang.Double.longBitsToDouble(longBits);
	}

	public byte[] doubleToLittleEndianArray8(Double number){
		byte[] array=new byte[8];
		long l = Double.doubleToLongBits(number);
		array[0]=(byte)((l>>0)&0xFFL);
		array[1]=(byte)((l>>8)&0xFFL);
		array[2]=(byte)((l>>16)&0xFFL);
		array[3]=(byte)((l>>24)&0xFFL);
		array[4]=(byte)((l>>32)&0xFFL);
		array[5]=(byte)((l>>40)&0xFFL);
		array[6]=(byte)((l>>48)&0xFFL);
		array[7]=(byte)((l>>56)&0xFFL);

		return array;
	}


	public long littleEndianArray8ToLong(byte[] array){
		return(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24)|(((long)array[4]&0xFFL)<<32)|(((long)array[5]&0xFFL)<<40)|(((long)array[6]&0xFFL)<<48)|(((long)array[7]&0xFFL)<<56);
	}

	public byte[] longToLittleEndianArray8(long number){
		byte[] array=new byte[8];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);
		array[4]=(byte)((number>>32)&0xFFL);
		array[5]=(byte)((number>>40)&0xFFL);
		array[6]=(byte)((number>>48)&0xFFL);
		array[7]=(byte)((number>>56)&0xFFL);

		return array;
	}


	public long littleEndianArray4ToLong(byte[] array){
		return(((long)array[0]&0xFFL)<<0)|(((long)array[1]&0xFFL)<<8)|(((long)array[2]&0xFFL)<<16)|(((long)array[3]&0xFFL)<<24);
	}

	public byte[] longToLittleEndianArray4(long number){
		byte[] array=new byte[4];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);

		return array;
	}


	public int littleEndianArray4ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8)|(((int)array[2]&0xFF)<<16)|(((int)array[3]&0xFF)<<24);
	}

	public byte[] intToLittleEndianArray4(int number){
		byte[] array=new byte[4];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);
		array[2]=(byte)((number>>16)&0xFFL);
		array[3]=(byte)((number>>24)&0xFFL);

		return array;
	}

	public int littleEndianArray2ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8);
	}

	public byte[] intToLittleEndianArray2(int number){
		byte[] array=new byte[2];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);

		return array;
	}


	public int littleEndianArray1ToInt(byte[] array){
		return(((int)array[0]&0xFF)<<0);
	}

	public byte[] intToLittleEndianArray1(int number){
		byte[] array=new byte[1];
		array[0]=(byte)((number>>0)&0xFFL);

		return array;
	}


	public short littleEndianArray2ToShort(byte[] array){
		return(short)(((((int)array[0]&0xFF)<<0)|(((int)array[1]&0xFF)<<8))&0xFFFF);
	}

	public byte[] shortToLittleEndianArray2(short number){
		byte[] array=new byte[2];
		array[0]=(byte)((number>>0)&0xFFL);
		array[1]=(byte)((number>>8)&0xFFL);

		return array;

	}


	public byte littleEndianArray1ToByte(byte[] array){
		return array[0];
	}

	public byte[] byteToLittleEndianArray1(byte number){
		byte[] array=new byte[1];
		array[0]=(byte)((number>>0)&0xFFL);

		return array;
	}


	public int getRecordSignature(){
		return littleEndianArray2ToInt(recordSignature);
	}

	public void putRecordSignature(int recordSignature){
		this.recordSignature=intToLittleEndianArray2(recordSignature);
	}

	public String getUserID(){
		return arrayToString(userID);
	}

	public void putUserID(String userID){
		this.userID=stringToArray(this.userID.length,userID);
	}

	public int getRecordID(){
		return littleEndianArray2ToInt(recordID);
	}

	public void putRecordID(int recordID){
		this.recordID=intToLittleEndianArray2(recordID);
	}

	public int getRecordLengthAfterHeader(){
		return littleEndianArray2ToInt(recordLengthAfterHeader);
	}

	public void putRecordLengthAfterHeader(int recordLengthAfterHeader){
		this.recordLengthAfterHeader=intToLittleEndianArray2(recordLengthAfterHeader);
	}

	public String getDescription(){
		return arrayToString(description);
	}

	public void putDescription(String description){
		this.description=stringToArray(this.description.length,description);
	}

	public byte[] getData(){
		return data;
	}

	public void putData(byte[] data){

			this.data=data;
	}

	public void print(){
		System.out.println("recordSignature "+getRecordSignature());
		System.out.println("userID "+getUserID());
		System.out.println("recordID "+getRecordID());
		System.out.println("recordLengthAfterHeader "+getRecordLengthAfterHeader());
		System.out.println("description "+getDescription());
                //System.out.println("data: "+arrayToBits(data));
	}

	public String arrayToBits(byte[] bytes){
		String string=new String();
		for(int a=0;a<bytes.length;a++){
			for(int b=7;b>-1;b--){
				string+=(bytes[a]>>>b)&0x01;
				if(b==4){
					string+=" ";
				}
				if(b==0){
					string+=" ";
				}
			}
		}
		return string;
	}

	public String arrayToHex(byte[] bytes){
		for(int a=0,c=1;a<bytes.length;a++,c++){
			if(bytes[a]==0x87){
				System.out.println(a);
			}
		}
		String string=new String();
		for(int a=0,c=1;a<bytes.length;a++,c++){
			if(bytes[a]==0xAF){
				System.out.println(a);
			}
			string+=Long.toHexString(((long)bytes[a])&0xFF)+" ";
			if(c==4){
				string+="\n";
				c=0;
			}
		}
		string+="\n";
		return string;
	}

	public GeoRefInfo parseGeoreferencingInformation(){
		GeoRefInfo georeferencingInformation=new GeoRefInfo(data);
		System.out.println(data.length);
		System.out.println(arrayToHex(data));
		return georeferencingInformation;
	}

	public static void main(String[] args){
		LASVariableLengthRecord lasvariablelengthrecord=new LASVariableLengthRecord();
		lasvariablelengthrecord.putRecordID(12);
		System.out.println(lasvariablelengthrecord.getRecordID());
		lasvariablelengthrecord.putRecordLengthAfterHeader(1234);
		System.out.println(lasvariablelengthrecord.getRecordLengthAfterHeader());
		lasvariablelengthrecord.putUserID("test");
		System.out.println(lasvariablelengthrecord.getUserID());
	}
}
